<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    // gli utenti di tipo articolista non possono accedere a questa pagina
    if($_SESSION["geecomAdmin_ruolo"]=="articolista") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("parolaChiave"=>$cerca) : array();
    $parametri = array("tabella"=>"geecB_ricercheEffettuate", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"ricercheEffettuate.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom CMS - ricerche effettuate</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
        <?php  
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>
    
     <!-- Modal box conferma cancellazione elemento-->
    <div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title" id="myModalLabel3">Eliminare l'utente: </h4>
          </div>
            <form class="form-horizontal" role="form" name="formCancellazione" action="utenti/cancellaUtente.php" method="post">
                <input type="text" class="hidden" id="utenteDaEliminare" name="idUtente" >
            </form>
          
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
            <button type="button" class="btn btn-primary" onclick="{document.formCancellazione.submit();}" >Elimina</button>
          </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <div class="text-right mb-3">
                        <a class="btn btn-outline-primary" href="statistiche.php"><i class="fas fa-arrow-left mr-2"></i>Torna indietro</a>
                    </div>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <a class="card-title mr-2"> Elenco ricerche</a>
                        </div>        
                    
                        <?php
                            if(isset($_GET["status"])) {
                                if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                                }
                                else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                                }
                                else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                                }
                                else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                                }
                                else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                                }
                            }
                        ?>

                    <div class="panel panel-default">
                        <div class="card-body collapse show">
                            <div class="table-responsive table-sm p-1">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <?php
                                    if(isset($_GET["pag"])) {
                                        $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                    }
                                    else {
                                        $ris = $ricerca->eseguiRicerca(1);
                                    }

                                    $colonne = array("ID","Tipo","Parola chiave","Ricerche effettuate","Prima ricerca","Ultima ricerca","");
                                    $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                    $tabella->setTipo("normale");
                                    while($ricercaEffettuata = $ris->fetch_assoc()) {
                                        $tabella->aggiungiNuovaRiga(array($ricercaEffettuata["id"],$ricercaEffettuata["tipo"],$ricercaEffettuata["parolaChiave"],$ricercaEffettuata["numeroRicerche"],date("d/m/Y",strtotime($ricercaEffettuata["primaRicerca"])),date("d/m/Y",strtotime($ricercaEffettuata["ultimaRicerca"]))),[]);
                                    }
                              
                                    $tabella->stampa("menu", 0);
                                    $ricerca->stampaPaginazione(true,"ricercheEffettuate.php");
                                ?>
                            </div>
                        </div>
                        <!-- /tabella -->
                    </div>
                </div>
            </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
            
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
    <div class="modal fade" id="modalEliminaRicerche" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare tutte le ricerche?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="paginaDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneMenu()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
	
    <script type="text/javascript">

        function eliminaMenu(id,nome) {
            $('#paginaDaEliminare').val(id);
            $('#nomeElementoDaEliminare').text(nome);
            $('#modalEliminaElemento').modal('show');
        }

        function eseguiEliminazioneMenu() {
            var id = $('#paginaDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../controller/controllerMenu.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("menu"+id).className = "d-none";
                        $('#modalEliminaElemento').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>